/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationFinal;

import java.io.Serializable;
import productsFinal.Item;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import static salesApplicationFinal.CompanyInfo.COPYRIGHT_NOTICE;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */

public class PriceList implements Serializable {

    //A collection of products that belong on our price list.
    public List<Item> list = new ArrayList<>();
    final LocalDate DATE_CREATED;
    
    /* Remove all this code
    final static String COPYRIGHT_NOTICE;
    
    static {
         //Try to initialise COPYRIGHT_NOTICE here.
        COPYRIGHT_NOTICE = "\u00A9 2018 Moving Stationery. "
            + "\nNo part of this price list may be reproduced digitally or physically "
            + "without the express permission of the company.";
    }*/
    
    public PriceList(){
        DATE_CREATED = LocalDate.now();
    }

    public List<Item> getList() {
        return list;
    }

    //Adds a product to our price list (provided their is no other product with that name).
    public void addProduct(Item newItem) {
        boolean exists=false;
        //If a product with this name already exists print out a message and stop.
        for (Item p : list) {
            if (p.equals(newItem)) {
                System.out.println("A product already exists with that name.");
                exists=true;
            }
        }
        if (!exists) {
            list.add(newItem);
        } else {}
    }

    //Removes a product on our price list based on the name of the product.
    public void removeProduct(String productName) {
        for (Item p : list) {
            if (p.getName().equals(productName)) {
                list.remove(p);
                return;
            }
        }
    }

    public void printList() {
        //Print out the price list
        System.out.println("== Price list (current as of " + DATE_CREATED + ") ==");

        //For each product in our list, print out the product details
        for (Item p : list) {
            //Put a blank line between each product
            System.out.println();
            //Get the product to print out the details
            p.printProduct();
        }
        System.out.println("== End of Price List ==");
        System.out.println();
        System.out.println(COPYRIGHT_NOTICE);
    }
}
